/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.commands;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.genetic.AgriAllele;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.genetic.AgriGeneRegistry;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7157;

public class GiveSeedCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_PLANTS = (commandContext, suggestionsBuilder) -> class_2172.method_9270((Iterable)AgriApi.getPlantRegistry(((class_2168)commandContext.getSource()).method_30497()).map(class_2378::method_10235).orElse(Set.of()), (SuggestionsBuilder)suggestionsBuilder);

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"agricraft_seed").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"plant", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_PLANTS).executes(commandContext -> GiveSeedCommand.giveSeed((class_2168)commandContext.getSource(), class_2232.method_9443((CommandContext)commandContext, (String)"plant")))).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(commandContext -> GiveSeedCommand.giveSeed((class_2168)commandContext.getSource(), class_2232.method_9443((CommandContext)commandContext, (String)"plant"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count")))))).then(class_2170.method_9247((String)"distinct").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(commandContext -> GiveSeedCommand.giveSeed((class_2168)commandContext.getSource(), class_2232.method_9443((CommandContext)commandContext, (String)"plant"), StringArgumentType.getString((CommandContext)commandContext, (String)"value")))))));
    }

    public static int giveSeed(class_2168 source, class_2960 plant) {
        Optional<AgriPlant> optional = AgriApi.getPlant(plant, source.method_9225().method_30349());
        if (optional.isEmpty()) {
            return 0;
        }
        class_1799 itemStack = AgriSeedItem.toStack(optional.get());
        if (GiveSeedCommand.giveItemStack(itemStack, source.method_44023(), source.method_9225())) {
            source.method_9226(() -> class_2561.method_43469((String)"agricraft.command.seed_default", (Object[])new Object[]{plant}), true);
            return 1;
        }
        return 0;
    }

    public static int giveSeed(class_2168 source, class_2960 plant, int value) {
        AgriAllele<String> allele = AgriGeneRegistry.getInstance().getGeneSpecies().getAllele(plant.toString());
        AgriGenome genome = new AgriGenome(new AgriGenePair<String>(AgriGeneRegistry.getInstance().getGeneSpecies(), allele), AgriStatRegistry.getInstance().stream().sorted(Comparator.comparing(AgriStat::getId)).map(stat -> AgriGeneRegistry.getInstance().getGeneStat((AgriStat)stat)).filter(Optional::isPresent).map(Optional::get).map(gene -> new AgriGenePair<Integer>((AgriGene<Integer>)gene, gene.getAllele(value))).toList());
        class_1799 itemStack = AgriSeedItem.toStack(genome);
        if (GiveSeedCommand.giveItemStack(itemStack, source.method_44023(), source.method_9225())) {
            source.method_9226(() -> class_2561.method_43469((String)"agricraft.command.seed_all", (Object[])new Object[]{plant, value}), true);
            return 1;
        }
        return 0;
    }

    private static int giveSeed(class_2168 source, class_2960 plant, String distincts) {
        int i;
        AgriAllele<String> allele = AgriGeneRegistry.getInstance().getGeneSpecies().getAllele(plant.toString());
        List<AgriGene> genes = AgriStatRegistry.getInstance().stream().sorted(Comparator.comparing(AgriStat::getId)).map(stat -> AgriGeneRegistry.getInstance().getGeneStat((AgriStat)stat)).filter(Optional::isPresent).map(Optional::get).toList();
        ArrayList<AgriGenePair<Integer>> genePairs = new ArrayList<AgriGenePair<Integer>>();
        String[] split = distincts.split("-");
        int[] values = new int[AgriStatRegistry.getInstance().size()];
        Arrays.fill(values, 1);
        for (i = 0; i < split.length; ++i) {
            String s = split[i];
            try {
                values[i] = class_3532.method_15340((int)Integer.parseInt(s), (int)1, (int)10);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (i = 0; i < genes.size() && i < values.length; ++i) {
            AgriGene gene = genes.get(i);
            genePairs.add(new AgriGenePair<Integer>(gene, gene.getAllele(values[i])));
        }
        AgriGenome genome = new AgriGenome(new AgriGenePair<String>(AgriGeneRegistry.getInstance().getGeneSpecies(), allele), genePairs);
        class_1799 itemStack = AgriSeedItem.toStack(genome);
        if (GiveSeedCommand.giveItemStack(itemStack, source.method_44023(), source.method_9225())) {
            source.method_9226(() -> class_2561.method_43469((String)"agricraft.command.seed_distinct", (Object[])new Object[]{plant, distincts}), true);
            return 1;
        }
        return 0;
    }

    private static boolean giveItemStack(class_1799 itemStack, class_3222 player, class_3218 level) {
        boolean added = player.method_31548().method_7394(itemStack);
        if (!added || !itemStack.method_7960()) {
            class_1542 itemEntity = player.method_7328(itemStack, false);
            if (itemEntity == null) {
                return false;
            }
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
        player.field_7512.method_7623();
        return true;
    }
}

